﻿using System;
using System.Text;
using System.Xml;

namespace AHOBPR_Job_Runner.DasXml
{
    [Serializable]
    public class Facility
    {
        public String Id { get; set; }
        public String Jurisdiction { get; set; }
        public String Name { get; set; }

        public void GetXml(XmlWriter writer)
        {
            String prefix = "nc";
            writer.WriteStartElement(prefix, "Facility", prefix);
            writer.WriteWhitespace("\r\n\t\t\t");

            //ID:
            {
                writer.WriteStartElement(prefix, "FacilityIdentification", prefix);
                writer.WriteWhitespace("\r\n\t\t\t\t");
                {
                    //ID:
                    {
                        writer.WriteElementString(prefix, "IdentificationID", prefix, Id);
                        writer.WriteWhitespace("\r\n\t\t\t\t");
                    }
                    //Jurisdiction:
                    {
                        writer.WriteElementString(prefix, "IdentificationJurisdictionText", prefix, Jurisdiction);
                        writer.WriteWhitespace("\r\n\t\t\t");
                    }
                }
                writer.WriteEndElement();
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Facility Name:
            {
                writer.WriteElementString(prefix, "FacilityName", prefix, Name);
                writer.WriteWhitespace("\r\n\t\t");
            }

            writer.WriteEndElement();
            writer.WriteWhitespace("\r\n\t");
        }
    }
}
